import React from "react";
import Doctor from "../Assets/doctor-group.png";
import SolutionStep from "./SolutionStep";
import "../Styles/About.css";
import DoctorCard from "./DoctorCard";
import doctorImage from '../Assets/7.jpeg';
import Navbar from "./Navbar"; // Assuming Navbar component is defined here
import Footer from "./Footer"; // Assuming Footer component is defined here
import "../Styles/Footer.css"; 

function About() {
  return (
    <>
    <div className=" about-section" id="about">


      <div className="about-image-content">
        <img src={doctorImage} alt="Doctor Group" className="about-image1" />
      </div>

      <div className="about-text-content">
        <h3 className="about-title">
          <span>About Us</span>
        </h3>
        <p className="about-description">
          Where Patients Matter Most"

          Ashfaq Memorial Hospital at present enjoys an examplary reputation by virtue of providing efficient and humane service to its patients at all times. Commercial aspects have been totally superseded by the patients needs and treatment, hence our slogan "Where Patients Matter Most
        </p>

        <h4 className="about-text-title">Your Solutions</h4>

        <SolutionStep
          title="Choose a Specialist"
          description="Find your perfect specialist and book with ease at Health Plus. Expert doctors prioritize your health, offering tailored care." />

        <SolutionStep
          title="Make a Schedule"
          description="Choose the date and time that suits you best, and let our dedicated team of medical professionals ensure your well-being with personalized care." />

        <SolutionStep
          title="Get Your Solutions"
          description="Our experienced doctors and specialists are here to provide expert advice and personalized treatment plans, helping you achieve your best possible health." />
      </div>

    </div>
    </>
  );
}

export default About;
