import React from "react";
import InformationCard from "./InformationCard";
import { faHeartPulse, faTruckMedical, faTooth, faHospital, faFlask, faUserMd, faCapsules, faMicroscope, faAmbulance } from "@fortawesome/free-solid-svg-icons";
import "../Styles/Info.css";

function Info() {
  return (
    <div className="info-section" id="services">
      <div className="info-title-content">
        <h3 className="info-title">
          <span>What We Do</span>
        </h3>
        <p className="info-description">
          We bring healthcare to your convenience, offering a comprehensive
          range of on-demand medical services tailored to your needs. Our
          platform allows you to connect with experienced online doctors who
          provide expert medical advice, issue online prescriptions, and offer
          quick refills whenever you require them.
        </p>
      </div>

      <div className="info-cards-content">
        <InformationCard
          title="Emergency Care"
          description="Our Emergency Care service is designed to be your reliable support
            in critical situations. Whether it's a sudden illness, injury, or
            any medical concern that requires immediate attention, our team of
            dedicated healthcare professionals is available 24/7 to provide
            prompt and efficient care."
          icon={faHospital}
        />

        <InformationCard
          title="Children OPD"
          description="A special OPD for children is located next to NICU, manned by nurses and doctors around the clock. Since its inception, OPD has proved to be of great help to sources of children who need immense medical attention while the GPs are not available at odd times."
          icon={faCapsules}
        />

        <InformationCard
          title="Operation Theatres"
          description="There are two fully equipped and well-staffed operation theatres catering to all surgical specialties except cardiac surgery. These theatres, located next to the ICU and labour rooms, ensure centralized availability of essential services at the shortest notice, providing proper intensive services to patients and their attendants."
          icon={faMicroscope}
        />

        <InformationCard
          title="Neonatal Intensive Care Unit (NICU) & Paediatric Ventilators:"
          description="The NICU is a prime department equipped with top-notch machinery and services. It includes two ventilators, 11 incubators, and two resuscitation trolleys, one being an original Atom's machine."
          icon={faMicroscope}
        />

        <InformationCard
          title="Pharmacy"
          description="Pharmacy with a staff of more than 15 people provides service to outdoor and indoor patients 24 hours a day. The best part is the extreme care taken to keep medicines in adequate temperature and proper conditions."
          icon={faFlask}
        />

        <InformationCard
          title="Laboratory"
          description="Laboratory is the backbone of a hospital, hence there is always a need for a modern laboratory which is indoors. Labs are the biggest revenue generators, but AMH has overlooked this essential source of income for the sake of availability and reliable laboratory."
          icon={faUserMd}
        />

        <InformationCard
          title="Ultrasound"
          description="There are four ultrasound specialties, 3 females, and 1 male providing services to outdoor and indoor patients. The hospital has acquired brand new machines and printers, and the facility of transvaginal sonography and echocardiography are available."
          icon={faMicroscope}
        />

        <InformationCard
          title="Intensive Care Unit (ICU)"
          description="The Intensive Care Unit (ICU) at Ashfaq Memorial Hospital is a modern, fully equipped facility providing delicate and prompt services to serious patients, including post-operative cases. The ICU is air-conditioned, with strict surveillance for infections and equipment functions. It maintains high sterility standards and offers care from consultants across various disciplines. Recent extensions and refurbishments have enhanced its charm and provided a healthier environment for patients' utmost care."
          icon={faAmbulance}
        />
      </div>
    </div>
  );
}

export default Info;
