// import React, { useState } from "react";
// import { customerReviews } from "../Scripts/reviews";
// import "../Styles/Reviews.css";

// function Reviews() {
//   let rMessage, rName, rLocation;
//   const reviewsLength = customerReviews.length - 1;
//   const [review, setReview] = useState(0);

//   // back to previous review
//   const backBtnClick = () => {
//     setReview(review <= 0 ? reviewsLength : review - 1);
//     handleReviewsUpdation();
//   };

//   // go to newer review
//   const frontBtnClick = () => {
//     setReview(review >= reviewsLength ? 0 : review + 1);
//     handleReviewsUpdation();
//   };

//   // update reviews
//   const handleReviewsUpdation = () => {
//     const reviewMessage = customerReviews[review];
//     rName = reviewMessage.name;
//     rLocation = reviewMessage.location;
//     rMessage = reviewMessage.message;
//   };

//   // list review on visit
//   handleReviewsUpdation();

//   return (
//     <div className="review-section" id="reviews">
//       <div className="rw-text-content">
//         <p className="rw-text-title">
//           More over <span className="rw-text-num">1500+ Customers</span>
//         </p>

//         <p className="rw-text-desc">Don't believe us, Check clients word</p>

//         <p className="rw-text-format">
//           <span className="rw-text-quote1">''</span>
//           <span className="rw-review">{rMessage}</span>
//           <span className="rw-text-quote2">''</span>
//         </p>

//         <div className="rw-authors">
//           <div className="rw-names">
//             <p className="rw-reviewer-name">{rName}</p>
//             <p className="rw-reviewer-place">{rLocation}</p>
//           </div>

//           <div className="rw-btns">
//             <button
//               className="rw-next-btn"
//               type="button"
//               onClick={backBtnClick}
//             >
//               ←
//             </button>
//             <button
//               className="rw-next-btn"
//               type="button"
//               onClick={frontBtnClick}
//             >
//               →
//             </button>
//           </div>
//         </div>
//       </div>
//     </div>
//   );
// }

// export default Reviews;
// C:\Users\Anosha\Desktop\udemy\MyWork\Health-Plus\src\Components\Reviews.js

import React, { useState } from "react";
import { customerReviews } from "../Scripts/reviews"; // Assuming this import correctly points to your reviews data
import "../Styles/Reviews.css";

function Reviews() {
  const [currentReviewIndex, setCurrentReviewIndex] = useState(0);
  const reviewsLength = customerReviews.length;

  // Function to determine sentiment (simple demo, replace with actual logic)
  const getSentiment = (message) => {
    // Simple example: Check if message contains positive/negative words
    const words = message.toLowerCase().split(" ");
    const positiveWords = ["good", "great", "excellent", "fantastic"];
    const negativeWords = ["bad", "poor", "terrible", "awful"];

    let sentiment = 0;
    words.forEach(word => {
      if (positiveWords.includes(word)) sentiment++;
      if (negativeWords.includes(word)) sentiment--;
    });

    return sentiment >= 0 ? "Positive" : "Negative";
  };

  // Navigate to previous review
  const backBtnClick = () => {
    setCurrentReviewIndex(prevIndex => (prevIndex <= 0 ? reviewsLength - 1 : prevIndex - 1));
  };

  // Navigate to next review
  const frontBtnClick = () => {
    setCurrentReviewIndex(prevIndex => (prevIndex >= reviewsLength - 1 ? 0 : prevIndex + 1));
  };

  // Retrieve current review details
  const { name, location, message } = customerReviews[currentReviewIndex];
  const sentiment = getSentiment(message); // Determine sentiment for the current review

  return (
    <div className="review-section" id="reviews">
      <div className="rw-text-content">
        <p className="rw-text-title">
          More than <span className="rw-text-num">{reviewsLength} Customers</span>
        </p>

        <p className="rw-text-desc">Don't just take our word for it, hear from our clients:</p>

        <p className="rw-text-format">
          <span className="rw-text-quote1">''</span>
          <span className="rw-review">{message}</span>
          <span className="rw-text-quote2">''</span>
        </p>

        <div className="rw-authors">
          <div className="rw-names">
            <p className="rw-reviewer-name">{name}</p>
            <p className="rw-reviewer-place">{location}</p>
          </div>

          <div className="rw-sentiment">
            <p className="rw-sentiment-label">Sentiment:</p>
            <p className={`rw-sentiment-value ${sentiment === "Positive" ? 'positive' : 'negative'}`}>
              {sentiment}
            </p>
          </div>

          <div className="rw-btns">
            <button
              className="rw-next-btn"
              type="button"
              onClick={backBtnClick}
              disabled={reviewsLength <= 1} // Disable back button if there's only one review
            >
              ←
            </button>
            <button
              className="rw-next-btn"
              type="button"
              onClick={frontBtnClick}
              disabled={reviewsLength <= 1} // Disable next button if there's only one review
            >
              →
            </button>
          </div>
        </div>
      </div>
    </div>
  );
}

export default Reviews;
